﻿<%@ Page Title="Patient Related Lab Tests" Language="C#" MasterPageFile="~/Custom/EFR/Efr.Master" 
    AutoEventWireup="True" CodeBehind="PatientRelatedLabTests.aspx.cs" Inherits="VIRP_WEB.Custom.EFR.PatientRelatedLabTests" %>

<%@ Register src="~/Controls/Custom/EFR/RelatedLabDetails.ascx" tagname="RelatedLabDetails" tagprefix="UserControl" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" Runat="Server">
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" Runat="Server">
    
    <asp:Panel runat="server" ID="PanelPatientInfo" GroupingText="&nbsp;Patient Information&nbsp;">
        <br />
        <asp:Label SkinID="DataLabel" ID="LabelforLabelPatientName" runat="server" AssociatedControlID="LabelPatientName" ToolTip="Patient Name" >Patient Name:&nbsp;&nbsp;</asp:Label>
        <asp:Label SkinID="DataLabel" ID="LabelPatientName" runat="server" ToolTip="Patient Name"/>
        <br />
        <br />
        <asp:Label SkinID="DataLabel" ID="LabelforLabelPatientSnum" runat="server" AssociatedControlID="LabelPatientSnum" ToolTip="Patient SSN" > SSN:&nbsp;&nbsp;</asp:Label>
        <asp:Label SkinID="DataLabel" ID="LabelPatientSnum" runat="server" ToolTip="Patient SSN" />
    </asp:Panel>

    <br />
    <br />

    <asp:Panel runat="server" ID="PanelRelatedLabTests"  GroupingText="&nbsp;Related Lab Tests&nbsp;">
    <asp:Repeater ID="RepeaterRelatedLabTests" runat="server" DataSourceID="ObjectDataSourceRelatedLabTests">
         <ItemTemplate>
            <table style="width:100%">
            <tr>
                <td style="width:50%">
                  <asp:Label ID="LabelforLabelTestName" runat="server" AssociatedControlID="LabelTestName" ToolTip="Related Lab Test Name">Test Name:&nbsp;&nbsp;</asp:Label>
                   <asp:Label ID="LabelTestName"  runat="server" ToolTip="Related Lab Test Name" 
                       Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("LAB_TEST_NAME"))) %>' >
                   </asp:Label>
                </td>
                <td>
                   <asp:Label ID="LabelforLabelSpecimenType" runat="server" AssociatedControlID="LabelSpecimenType" ToolTip="Specimen Type" >SpecimenType:&nbsp;&nbsp;</asp:Label>
                    <asp:Label ID="LabelSpecimenType" runat="server" ToolTip="Specimen Type" 
                        Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("SPECIMEN_TYPE"))) %>' >
                    </asp:Label>
               </td>
            </tr>
            <tr><td>&nbsp;<br/></td></tr>
            <tr>
            <td colspan="2">
                <UserControl:RelatedLabDetails ID="RelatedLabDetails" runat="server"
                 PatientID='<%# Eval("PATIENT_ID") %>' LabName='<%# Eval("LAB_TEST_NAME") %>' SpecimenType='<%# Eval("SPECIMEN_TYPE") %>' />
            </td>
            </tr>
            </table>
            <br />
         </ItemTemplate>
         <FooterTemplate>
            <table runat="server" style="border: 3px solid grey" visible='<%# RepeaterRelatedLabTests.Items.Count == 0 %>'>
                 <tr>
                     <td>         
                     <asp:Label ID="lblEmptyData"
                            Text="No Records Available" runat="server" Visible='<%# RepeaterRelatedLabTests.Items.Count == 0 %>'>
                     </asp:Label>
                     </td> 
                 </tr>
             </table>           
         </FooterTemplate>
    </asp:Repeater>
    </asp:Panel>

    <asp:ObjectDataSource ID="ObjectDataSourceRelatedLabTests" runat="server" 
        SelectMethod="GetItemsByPatientId" 
        TypeName="VIRP.EFR.BLL.RELATED_LAB_TESTManager"
        DataObjectTypeName="VIRP.EFR.BO.RelatedLabTestView">
        <SelectParameters>
            <asp:Parameter Name="CURRENT_USER" Type="String" />
            <asp:Parameter Name="CURRENT_REGISTRY_ID" Type="Int32" />
            <asp:QueryStringParameter DefaultValue="0" Name="PATIENT_ID" QueryStringField="patientid" Type="Int32" />
        </SelectParameters>
    </asp:ObjectDataSource>

    <br /><br /><br /><br />

    <asp:LinkButton ID="LinkButtonPatientInformation" runat="server" Text="Patient Information" ToolTip="Select to see patient information" style="padding:4px; border:1px solid white;" OnClick="LinkButtonPatientInformation_Click" />&nbsp;
    <asp:LinkButton ID="LinkButtonWorkflows" runat="server" Text="Workflows" ToolTip="Select to see workflows for patient" style="padding:4px; border:1px solid white;" OnClick="LinkButtonWorkflows_Click" />&nbsp;
    <asp:LinkButton ID="LinkButtonRelatedDiagnoses" runat="server" Text="Related Diagnoses" ToolTip="Select to see related diagnoses for patient" style="padding:4px; border:1px solid white;" OnClick="LinkButtonRelatedDiagnoses_Click" />
    <asp:LinkButton ID="LinkButtonImages" runat="server" Text="Images" ToolTip="Select to see images for patient" style="padding:4px; border:1px solid white;" OnClick="LinkButtonImages_Click" />&nbsp;

</asp:Content>

